#!/usr/bin/env python
# encoding: utf-8
"""
USAGE: python proc_bold_pred.py > db/boldpred.dat
"""

import os, glob


DIR      = '../bold-predictions-latest7-r/'
#DIR      = '../bold-predictions-latest7-r_MANUAL/'
BOLDPRED = [f for f in os.listdir(DIR) if f[0] != '.']
TRIALS   = sorted(list(set([ f[14:16] for f in BOLDPRED ])))
RUNS     = list(set([ f.split('_')[2] for f in BOLDPRED ]))
MODULES  = list(set([ f.split('_')[3] for f in BOLDPRED ]))
MODULES.sort()


def init_results():
    results = []
    for i in xrange(getfilelen()):
        results.append([])
    return results
    
def main():
    print 'RUN\tTRIAL\tTIME\t' + '\t'.join(MODULES)
    for run in RUNS:
        results = init_results()
        for module in MODULES:
            printtime = module == MODULES[0]
            i = 0
            for trial in TRIALS:
                filename = glob.glob('%sbold-response_%s_%s_%s_*.dat' % (DIR, str(trial), str(run), str(module)))[0]
                f_0 = open(filename, 'r')
                for line in f_0.readlines()[1:]:
                    if not line.strip():
                        continue
                    e_0 = line.split()
                    if printtime:
                        results[i].extend([run, trial, e_0[0], e_0[1]])
                    else:
                        results[i].append(e_0[1])
                    i += 1
                f_0.close()
        for result in results:
            print '\t'.join(result)

def getfilelen ():
    f_1 = open(DIR + BOLDPRED[0])
    l_1 = len(f_1.readlines()[1:])-1 # letzte Zeile immer leer
    return l_1 * len(TRIALS)
    
    
        
if __name__ == '__main__':
    main()
