;;; File: load-fang2006.lisp

;;; global vars

(load "globalvars.lisp")

;;;; local vars

;; Human data
(defparameter *ppc-right-fang*      '(849.80762987 852.279069767 850.075396825 854.919435216 850.769163763 853.199088146 853.135551948 862.827242525 853.344155844 858.243355482 852.103174603 860.460963455 855.746515679 857.243161094 857.047077922 866.171096346 856.516233766 863.806478405 860.619047619 860.34551495 858.995644599 863.441489362 854.982954545 867.365448505))
(defparameter *lipfc-right-actr*    '(755.215909091 758.90245478 754.365432099 753.233204134 756.106368564 755.91607565 756.503156566 759.322997416 757.686237374 759.356589147 755.75617284 753.367571059 756.81097561 756.741134752 759.059974747 762.742248062 759.716540404 760.647286822 757.966666667 756.210594315 758.18902439 758.959810875 758.961489899 764.401162791))
(defparameter *acc-right-actr*      '(758.423768939 763.732073643 757.097685185 758.011627907 766.905487805 762.918882979 760.055871212 769.322674419 759.036931818 764.999031008 759.069444444 760.375 767.104674797 762.277925532 760.111742424 767.899224806 758.411458333 765.466569767 758.225925926 759.310562016 765.847560976 761.857712766 759.099431818 768.20251938))
(defparameter *apfc-right-fang*     '(634.025 637.593023256 632.58 634.806976744 633.963414634 633.282978723 631.606818182 640.320930233 635.722727273 638.765116279 633.033333333 633.593023256 633.058536585 633.485106383 630.652272727 640.637209302 633.643181818 638.830232558 633.851111111 635.623255814 631.948780488 633.008510638 629.834090909 639.376744186))
(defparameter *caudate-right-actr*  '(677.237373737 680.855297158 675.516049383 679.183462532 680.571815718 676.279747833 675.124579125 686.311800172 677.694444444 681.427217916 677.672427984 678.825150732 683.702800361 678.613081166 677.283670034 684.131782946 678.448653199 681.610680448 678.030452675 680.424633936 682.490514905 679.486209614 679.471380471 683.621877692))
(defparameter *fusiform-right-actr* '(787.806818182 793.068313953 786.366666667 792.274709302 789.579268293 790.64162234 786.116477273 794.36627907 787.893465909 790.986918605 787.961805556 790.718023256 790.448170732 790.114361702 786.691051136 793.898255814 787.310369318 790.572674419 785.926388889 791.209302326 790.537347561 789.166888298 784.277698864 791.183139535))
(defparameter *motor-left-actr*     '(735.003787879 740.361918605 734.552777778 736.039244186 739.753556911 735.750443262 734.864109848 743.519379845 734.769886364 740.001453488 735.905555556 734.908914729 739.788109756 736.608156028 736.032670455 743.364825581 735.232481061 740.071705426 734.739351852 735.771317829 739.988821138 736.906471631 735.500473485 746.035368217 738.248106061 744.066375969 739.027314815 738.549418605 742.670223577 739.154698582))

(defparameter *bold-predictions-hash* (make-hash-table))
(defparameter *boldpath* (concatenate 'string (concatenate 'string "./bold-predictions-" *modelversion* "-r/")))

(defvar *run*)
(defvar *bold-response-start*)
(defvar *bold-response-end*)

;; BOLD parameters initially set to ACT-R default
(defvar *bold-scale*     0.75)
(defvar *bold-exp*       6)
(defvar *neg-bold-scale* 1)
(defvar  *neg-bold-exp*  15)
(defvar  *bold-positive* 1)
(defvar  *bold-negative* 0)


(defvar *module* 'retrieval)
(defvar *module*)
;(setf *module* 'production)

(defparameter *term-presentations* (list
;;; PREMISE1 PREMISE2 CONCLUSION SID EXPECTED POSSIBLEMODEL
    '(("A" "l" "B") ("B" "l" "C") ("A" "l" "C") 1 1 "NA") ; A is to the left of B, B is to the left of C. Is A to the left of C? Right.
    '(("A" "l" "B") ("B" "l" "C") ("C" "r" "A") 2 1 "NA")
    '(("A" "r" "B") ("B" "r" "C") ("A" "r" "C") 3 1 "NA")
    '(("A" "r" "B") ("B" "r" "C") ("C" "l" "A") 4 1 "NA")

    '(("A" "l" "B") ("B" "l" "C") ("A" "r" "C") 5 0 "NA")
    '(("A" "l" "B") ("B" "l" "C") ("C" "l" "A") 6 0 "NA")
    '(("A" "r" "B") ("B" "r" "C") ("A" "l" "C") 7 0 "NA")
    '(("A" "r" "B") ("B" "r" "C") ("C" "r" "A") 8 0 "NA")

    '(("B" "r" "A") ("B" "l" "C") ("A" "l" "C") 9 1 "NA")
    '(("B" "r" "A") ("B" "l" "C") ("C" "r" "A") 10 1 "NA")
    '(("B" "l" "A") ("B" "r" "C") ("A" "r" "C") 11 1 "NA")
    '(("B" "l" "A") ("B" "r" "C") ("C" "l" "A") 12 1 "NA")

    '(("B" "r" "A") ("B" "l" "C") ("A" "r" "C") 13 0 "NA")
    '(("B" "r" "A") ("B" "l" "C") ("C" "l" "A") 14 0 "NA")
    '(("B" "l" "A") ("B" "r" "C") ("A" "l" "C") 15 0 "NA")
    '(("B" "l" "A") ("B" "r" "C") ("C" "r" "A") 16 0 "NA")

    '(("A" "l" "B") ("C" "r" "B") ("A" "l" "C") 17 1 "NA")
    '(("A" "l" "B") ("C" "r" "B") ("C" "r" "A") 18 1 "NA")
    '(("A" "r" "B") ("C" "l" "B") ("A" "r" "C") 19 1 "NA")
    '(("A" "r" "B") ("C" "l" "B") ("C" "l" "A") 20 1 "NA")

    '(("A" "l" "B") ("C" "r" "B") ("A" "r" "C") 21 0 "NA")
    '(("A" "l" "B") ("C" "r" "B") ("C" "l" "A") 22 0 "NA")
    '(("A" "r" "B") ("C" "l" "B") ("A" "l" "C") 23 0 "NA")
    '(("A" "r" "B") ("C" "l" "B") ("C" "r" "A") 24 0 "NA")

    '(("B" "r" "A") ("C" "r" "B") ("A" "l" "C") 25 1 "NA")
    '(("B" "r" "A") ("C" "r" "B") ("C" "r" "A") 26 1 "NA")
    '(("B" "l" "A") ("C" "l" "B") ("A" "r" "C") 27 1 "NA")
    '(("B" "l" "A") ("C" "l" "B") ("C" "l" "A") 28 1 "NA")

    '(("B" "r" "A") ("C" "r" "B") ("A" "r" "C") 29 0 "NA")
    '(("B" "r" "A") ("C" "r" "B") ("C" "l" "A") 30 0 "NA")
    '(("B" "l" "A") ("C" "l" "B") ("A" "l" "C") 31 0 "NA")
    '(("B" "l" "A") ("C" "l" "B") ("C" "r" "A") 32 0 "NA")
))

(setf *currentswitches* (make-switches
    :showtask                'yes  ;; 'yes: present initial "S"
    :numberoftrainingtasks   0
    :numberofpremises        2
    :letterdistance          150
    :offer-conclusion        t
    :offer-model             nil        ; simultaneous presentation of all model terms
    :paced                   'externally ;;'self or 'externally
))

(load "utilities.lisp")
(load "r-nterm-latest7.lisp")



;; EXPERIMENT

(defmethod rpm-window-key-event-handler ((win rpm-window) key)
    (setf *total-time* (get-time))
    (setf *response* (string key))
    )

(defun do-experiment ()
    (reset)
    (setf *trial* 0)
    (setf *model-results* nil)
    
    ; the first tasks are treated as training tasks and therefore will not be permuted.
    (setf *taskarray* (permute-list *term-presentations*))

    (dolist (task *taskarray*)
        (setf *response* nil)
        (setf (focus-position *modelfocus*) 1)
        (setf (focus-position *premisefocus*) 1)
        (setf (focus-position *conclusionfocus*) 1)

        (setf *trial* (+ 1 *trial*))
        
        
        (let*
            ((nop (switches-numberofpremises *currentswitches*))
            (premises      (subseq task 0 nop))
            (conclusion     (nth nop task))
            (sid            (nth (+ nop 1) task))
            (expected       (nth (+ nop 2) task))
            (possiblemodel  (nth (+ nop 3) task))
            (window (open-exp-window "" :width 300 :height 300 :visible *window-visible*)))

(setf *sid* sid)

            (install-device window)
            (proc-display)
            
            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Present "S" ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            (add-text-to-exp-window :text "S" :x 150 :y 140)
            (if *actr-enabled-p*
                (progn
                    (proc-display)
                    (run-full-time 1 :real-time nil)))
            (clear-exp-window)
            (proc-display)

            ;;;;;;;;;;;;;;; 1.0 second idle ;;;;;;;;;;;;;;;
            (if *actr-enabled-p*
                (run-full-time 1 :real-time nil))
                
                
            (setf *bold-response-start* (mp-time))
            (let
                ((inc (no-output (car (sgp :bold-inc)))))
                (setf *bold-response-start* (* inc (floor *bold-response-start* inc))))


            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Present premises ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            
            (present-premises premises)

            (setf *response* nil)
            
            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Present conclusion ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
            
            (present-conclusion conclusion)
            
            ;; Write measured data into list
            (let*
                ((rt (- *total-time* *start-time*))
                
                (response *response*)
                (correct (if (or (and (string-equal response "r") (equal expected 1)) (and (string-equal response "f") (equal expected 0))) 1 0)))
                (unless (string-equal response " ")
                    (setf *model-results*
                        (append
                            *model-results*
                            (list
                                *trial*
                                sid
                                rt
                                correct      ; 0 if response != expected, 1 otherwise
                                response     ; key pressed
                                expected
                                possiblemodel)))))))
    *model-results*)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Present the premises ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;        
(defun present-premises (premises)
    (dolist (premise premises)
        ;; FOR EACH PREMISE DO THE FOLLOWING
        (let
            ((term1 (nth 0 premise))
             (modus (nth 1 premise))
             (term2 (nth 2 premise)))

            ;;;;;;;;;;;;;;; 1.5 seconds: present first term of the premise ;;;;;;;;;;;;;;;

            (if (string-equal modus "l")
                (add-text-to-exp-window :text term1 :x 90 :y 140)
                (add-text-to-exp-window :text term1 :x 190 :y 140))
            
            (if *actr-enabled-p*
                (progn
                    (proc-display)
                    (run-full-time 1.5 :real-time nil)))
            (clear-exp-window)

        ;;;;;;;;;;;;;;; 1.5 seconds: present second term of the premise ;;;;;;;;;;;;;;;

            (if (string-equal modus "l")
                (add-text-to-exp-window :text term2 :x 190 :y 140)
                (add-text-to-exp-window :text term2 :x 90 :y 140))
            
            (if *actr-enabled-p*
                (progn
                    (proc-display)
                    (run-full-time 1.5 :real-time nil)
                    (clear-exp-window)
                    (proc-display)
                    
                    ; 1 second break between premises
                    (run-full-time 1 :real-time nil))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Present the conclusion ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun present-conclusion (conclusion)
    (let
        ((term1 (nth 0 conclusion))
        (modus (nth 1 conclusion))
        (term2 (nth 2 conclusion)))

        ;;;;;;;;;;;;;;; 1.5 seconds: present first term of conclusion ;;;;;;;;;;;;;;;

        (if (string-equal modus "l")
            (add-text-to-exp-window :text term1 :x 90 :y 140)
            (add-text-to-exp-window :text term1 :x 190 :y 140))
            
            (setf *start-time* (get-time))
            
        (if *actr-enabled-p*
            (progn
                (proc-display)
                (run-full-time 1.5 :real-time nil)))

        (clear-exp-window)

        ;;;;;;;;;;;;;;; 1.5 seconds: present second term of conclusion ;;;;;;;;;;;;;;;

        (if (string-equal modus "l")
            (add-text-to-exp-window :text term2 :x 190 :y 140)
            (add-text-to-exp-window :text term2 :x 90 :y 140))

        (if *actr-enabled-p*
            (progn
                (proc-display)
                (run-full-time 1.5 :real-time nil)))

        ;; Answer procedure for conclusion
        (clear-exp-window)

        (if *actr-enabled-p*
            (progn
                (proc-display)
                
                ;(if (eq *module* 'manual)
                ;    ;; then
                ;    (run-full-time 4 :real-time nil)
                ;    ;; else
                ;    (run-full-time 1 :real-time nil))
                (run-full-time 1 :real-time nil)
                
                (setf *bold-response-end* (mp-time))
                
                ;(bold-response-to-hash *trial* *bold-response-start* *bold-response-end*)
                (bold-response-to-file *run* *trial* *bold-response-start* *bold-response-end*)
                
                ;(if (eq *module* 'manual)
                ;    ;; then
                ;    (run-full-time 8 :real-time nil)
                ;    ;; else
                ;    (run-full-time 11 :real-time nil))
                (run-full-time 11 :real-time nil)
                
                (proc-display)
                
                ; specific time between trials
                ;(run-full-time 16 :real-time nil)
                ))))


(defun do-n (n)
  "Writes the model results of n runs to a tab delimited file"
  (setf *runs* nil)
  (dotimes (counter n)

    (format t "~&~&~&~&~&----------------------------------------> ~d <----------------------------------------~%~%~%~%~%" (+ 1 counter))

		(let* ((r1 (do-experiment)))
	(setf *runs* (append *runs* r1))))

  (with-open-file (*standard-output* "fang2006-latest7.dat"
				     :direction :output
				     :if-exists :supersede
				     :if-does-not-exist :create)
    (print-table *runs*))

  (format t "~%File \'fang2006-latest7.dat\' written.~%"))
