#!/usr/bin/env python
# encoding: utf-8
"""
"""

import os, sqlite3
from scipy import stats
import csv

LATEST = 'latest7'
HOME = '/Users/bruessow/Documents/Freiburg/'
BOLD = HOME + 'act-r-modeling/extracted_data_psychrev/'
PRED = HOME + '../bold-predictions-latest7-r/'

HUMAN = [ filename for filename in os.listdir(BOLD) if filename[0] != '.' ]



class MyStderr:
    def __init__(self):
        self.values = []
    def step(self, value):
        self.values.append(value)
    def finalize(self):
        return stats.sem(self.values)



def get_file_info (filename):
    info = filename.split('.')[0].split('_')
    roidef, region, hemisphere, contrast = info
    return roidef, region, hemisphere.lower(), contrast # contrast refers to auxiliary contrast specification ('within', 'between')



def insert_bold(bc, bconn):
    
    # Create table
    bc.execute('''CREATE TABLE IF NOT EXISTS bolddb
        (id TEXT PRIMARY KEY,
        roi TEXT,
        mniidx TEXT,
        vpn INTEGER,
        run INTEGER,
        scannum INTEGER,
        x INTEGER,
        y INTEGER,
        z INTEGER,
        intensity REAL,
        tasktype TEXT,
        premise INTEGER,
        premisetime INTEGER,
        valid INTEGER,
        trialtime INTEGER,
        trialtime2 INTEGER,
        module TEXT,
        region TEXT,
        hemisphere TEXT,
        contrast TEXT,
        roidef TEXT,
        mapping TEXT)''')
        
    for fid, filename in enumerate(HUMAN):
        roidef, region, hemisphere, contrast = get_file_info(filename)
        
        if hemisphere == 'l':
            hemisphere = 'left'
        elif hemisphere == 'r':
            hemisphere = 'right'
        
        if roidef == 'actr':
            mapping = 'NA'
            
            if region == 'goal':
                module, region = region,'acc'
            elif region == 'imaginal':
                module, region = region,'ppc'
            elif region == 'manual':
                module, region = region,'motor'
            elif region == 'production':
                module, region = region,'caudate'
            elif region == 'retrieval':
                module, region = region,'lipfc'
            elif region == 'visual':
                module, region = region,'fusiform'
                
        elif roidef == 'fang':
            if region == 'pfc':
                module = 'retrieval'
                mapping = 'NA'
            elif region == 'otc':
                module = 'visual'
                mapping = 'NA'
            elif region == 'ppc':
                module = 'imaginal'
                mapping = 'NA'
            elif region == 'apfc':
                module = 'goal'
                mapping = 'a'
            elif region == 'acc':
                module = 'goal'
                mapping = 'b'
            elif region == 'caudate':
                module = 'production'
                mapping = 'NA'
                
        print roidef, module, region, hemisphere, contrast, mapping, filename
        
        f = open(BOLD + filename, 'r')
        
        ### Insert a row of data
        for lid, line in enumerate(f.readlines()[1:]):
            idx = str(fid) + '-' + str(lid)
            entries =  idx + '", "' + line.strip().replace('\t', '", "') + '", NULL, NULL, "' + module + '", "' + region + '", "' + hemisphere + '", "' + contrast + '", "' + roidef + '", "' + mapping
            bc.execute('INSERT INTO bolddb VALUES ("%s")' % (entries))
        
        ### close file
        f.close()
    
    ### Save (commit) the changes
    bconn.commit()




def insert_pred(pc, pconn):
    
    #RUN    TRIAL   TIME    GOAL    MANUAL  VISUAL-LOCATION VISUAL  PRODUCTION  IMAGINAL    RETRIEVAL
    # Create table
    pc.execute('''CREATE TABLE IF NOT EXISTS preddb
        (id TEXT PRIMARY KEY,
        run INT,
        trial TEXT,
        time REAL,
        goal REAL,
        manual REAL,
        visuallocation REAL,
        visual REAL,
        production REAL,
        imaginal REAL,
        retrieval REAL,
        mintime REAL,
        trialtime INTEGER,
        trialtime2 INTEGER,
        model TEXT
        )'''
        )
        
    f = open('./db/boldpred.dat', 'r')
    
    ### Insert a row of data
    reader = csv.DictReader(f, delimiter = '\t')
    for lid, row in enumerate(reader):
        idx = str(lid)
        run            = row['RUN']
        trial          = row['TRIAL']
        time           = row['TIME']
        goal           = row['GOAL']
        imaginal       = row['IMAGINAL']
        manual         = row['MANUAL']
        production     = row['PRODUCTION']
        retrieval      = row['RETRIEVAL']
        visual         = row['VISUAL']
        visuallocation = row['VISUAL-LOCATION']
        
        pc.execute('INSERT INTO preddb VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)', (idx, run, trial, time, goal, imaginal, manual, production, retrieval, visual, visuallocation, 0, 0, 0, LATEST))
        
    ### close file
    f.close()
    ### Save (commit) the changes
    pconn.commit()
    
    pc.execute('''SELECT MIN(time), run, trial FROM preddb
        GROUP BY trial
        ORDER BY time''')
        
    pcrows = pc.fetchall()
        
    for mintime, run, trial in pcrows:
        pc.execute('UPDATE preddb SET mintime = "%s" WHERE run = "%s" AND trial = "%s"' % (mintime, run, trial))
    pconn.commit()
        
    pc.execute('SELECT time, mintime FROM preddb')
    
    pcrows = pc.fetchall()
    for time, mintime in pcrows:
        trialtime = (time-mintime)*1000
        pc.execute('UPDATE preddb SET trialtime="%s" WHERE time="%s"' % (trialtime, time))
    pconn.commit()



def db_dump (c, filename, variables):
    if os.path.exists(filename):
        os.rename(filename, '#' + filename + '#')
    
    f = open(filename, 'w')
    f.write('\t'.join([v for v in variables]) + '\n')
    for row in c:
        f.write('\t'.join([str(r) for r in row]) + '\n')
    f.close()
    print '"' + filename + '"' + ' written.'



def main():
    bdbexists = os.path.exists('./db/_bold.sqlite')
    bconn = sqlite3.connect('./db/_bold.sqlite')
    bconn.create_aggregate("MYSTDERR", 1, MyStderr)
    bc = bconn.cursor()
    if not bdbexists:
        insert_bold(bc, bconn)

    pdbexists = os.path.exists('./db/_pred.sqlite')
    pconn = sqlite3.connect('./db/_pred.sqlite')

    pc = pconn.cursor()
    if not pdbexists:
        insert_pred(pc, pconn)
    
    bc.execute('''SELECT roi, premisetime, AVG(intensity), MYSTDERR(intensity), tasktype, premise, trialtime, trialtime2,  module, region, hemisphere, roidef, contrast, mapping FROM bolddb 
        WHERE tasktype="R"
        GROUP BY roi, premisetime, tasktype, premise''')
    
    pc.execute('SELECT * FROM preddb')
    
    db_dump(bc, './db/_bold.dat', ['ROI', 'PREMISETIME', 'INTENSITY', 'STDERR', 'TASKTYPE', 'PREMISE', 'TRIALTIME', 'TRIALTIME2', 'MODULE', 'REGION', 'HEMISPHERE', 'ROIDEF', 'CONTRAST', 'MAPPING'])
    db_dump(pc, './db/_pred.dat', ['ID', 'RUN', 'TRIAL', 'TIME', 'GOAL', 'IMAGINAL', 'MANUAL', 'PRODUCTION', 'RETRIEVAL', 'VISUAL', 'VISUALLOCATION', 'MINTIME', 'TRIALTIME', 'TRIALTIME2', 'MODEL'])
    
    #close cursor
    bc.close()
    pc.close()

if __name__ == '__main__':
    main()
