bd <- read.table("./db/_bold.dat", header=T)
pd <- read.table("./db/_pred.dat", header=T)


# Visual
bd.v <- subset(bd, REGION=="fusiform" & HEMISPHERE=="right" & ROIDEF=="actr")
bd.v.tt1 <- aggregate(bd.v$INTENSITY, by=list(bd.v$TRIALTIME2, bd.v$TRIALTIME), FUN=mean)
pd.v.tt1 <- aggregate(pd$VISUAL, by=list(pd$TRIALTIME2, pd$TRIALTIME), FUN=mean)
colnames(pd.v.tt1) <- c("tt2", "tt1", "i")
colnames(bd.v.tt1) <- c("tt2", "tt1", "i")
cor.test(bd.v.tt1$i, pd.v.tt1$i)

bd.v.tt2 <- aggregate(bd.v$INTENSITY, by=list(bd.v$TRIALTIME2), FUN=mean)
pd.v.tt2 <- aggregate(pd$VISUAL, by=list(pd$TRIALTIME2), FUN=mean)
colnames(pd.v.tt2) <- c("tt2", "i")
colnames(bd.v.tt2) <- c("tt2", "i")
cor.test(bd.v.tt2$i, pd.v.tt2$i)
cor.test(bd.v.tt2$i[2:11], pd.v.tt2$i[2:11])


# Goal
bd.g <- subset(bd, REGION=="apfc" & HEMISPHERE=="right" & ROIDEF=="fang")
bd.g.tt1 <- aggregate(bd.g$INTENSITY, by=list(bd.g$TRIALTIME2, bd.g$TRIALTIME), FUN=mean)
pd.g.tt1 <- aggregate(pd$GOAL, by=list(pd$TRIALTIME2, pd$TRIALTIME), FUN=mean)
colnames(pd.g.tt1) <- c("tt2", "tt1", "i")
colnames(bd.g.tt1) <- c("tt2", "tt1", "i")
cor.test(bd.g.tt1$i, pd.g.tt1$i)

bd.g.tt2 <- aggregate(bd.g$INTENSITY, by=list(bd.g$TRIALTIME2), FUN=mean)
pd.g.tt2 <- aggregate(pd$GOAL, by=list(pd$TRIALTIME2), FUN=mean)
colnames(pd.g.tt2) <- c("tt2", "i")
colnames(bd.g.tt2) <- c("tt2", "i")
cor.test(bd.g.tt2$i, pd.g.tt2$i)
cor.test(bd.g.tt2$i[2:12], pd.g.tt2$i[2:12])