;;; File    : utilities.lisp

(defun move-focus-right (focus)
  (let* ((pos (+ (focus-position focus) 1)))
    (setf (focus-position focus) pos)
    (append  (list (read-from-string
            (concatenate 'string "pos"
                 (write-to-string (focus-position focus))))))))


(defun move-focus-left (focus)
  (let* ((pos (- (focus-position focus) 1)))
     (setf (focus-position focus) pos)
    (append  (list (read-from-string
            (concatenate 'string "pos"
                 (write-to-string (focus-position focus))))))))

(defun set-focus (pos focus)
  (let* ((posname (symbol-name pos))
     (num (parse-integer
           (subseq posname 3 (length posname)))))
    (setf (focus-position focus) num)
        ))

(defun extend-left (leftborder)
  "This function returns a new slot name for mental model chunk. Formally the
  extend-chunk-type-slots function has been used to add new slots to an existing
  chunk on demand. In the latest ACT-R version this happens automatically. "
  (let* ((posname (symbol-name leftborder))
     (newslot (concatenate 'string "pos"
                   (write-to-string (- (parse-integer (subseq posname 3 (length posname))) 1)))))
    (read-from-string newslot)))

(defun extend-right (rightborder)
  "This function returns a new slot name for mental model chunk. Formally the
  extend-chunk-type-slots function has been used to add new slots to an existing
  chunk on demand. In the latest ACT-R version this happens automatically. "
  (let* ((posname (symbol-name rightborder))
    (newslot (concatenate 'string "pos"
                (write-to-string (+ (parse-integer (subseq posname 3 (length posname))) 1)))))
    (read-from-string newslot)))

(defun print-table (runs)
    (format t "~&TRIAL~15TSID~30TRT~45TCORRECT~60TRESPONSE~75TEXPECTED~90TDET~{~&~A~15T~A~30T~A~45T~A~60T~A~75T~A~90T~A~}" runs)
)

(defun answer-given ()
    "Function necessary for (run-until-condition) in experiment file. While no answer is given, the return value is nil, else the respective pressed key."
    *response*)


(defun bold-response-to-file (run trial start end)
"This function writes the predicted BOLD responses for a specific trial to a file.
It is called from the method  RPM-WINDOW-KEY-EVENT-HANDLER that returns the key that
has been pressed by the model.  The endtime is taken in the same method.The starttime
is taken in the first production READ-MODE that is the first production to fire."
  (let ((tnum nil)
        (sid nil)
        (utime (write-to-string (get-universal-time)))
        (mstrg (write-to-string *module*))
        (rstrg (write-to-string run)))
    (if (< trial 10)
    (setf tnum (concatenate 'string "0" (write-to-string trial)))
    (setf tnum (write-to-string trial)))
    (if (< *sid* 10)
    (setf sid (concatenate 'string "0" (write-to-string *sid*)))
    (setf sid (write-to-string *sid*)))
    (with-open-file (*standard-output*
        (concatenate 'string *boldpath* "bold-response_" tnum "_" rstrg "_" mstrg "_" sid "_" utime ".dat")
             :direction :output
             :if-exists :supersede
             :if-does-not-exist :create)
      (predict-bold-response start end))))

(defun bold-response-to-hash (trial start end)
"This function saves the predicted BOLD responses for a specific trial and module to a
hash table. The BOLD parameters are fitted automatically and the function GETCORRELATION
uses this hash table with the human data corresponding to the fitted module and returns
the parameter setting leading to the best correlation.
BOLD-RESPONSE-TO-HASH is called from the method  RPM-WINDOW-KEY-EVENT-HANDLER that returns
the key that has been pressed by the model.  The endtime is taken in the same method.The starttime
is taken in the first production READ-MODE that is the first production to fire."
(do ((scale 0.01  (+ 0.01 scale))) ((> scale 0.3))
  ;(do ((neg-scale 0.01  (+ 0.01 neg-scale))) ((> neg-scale 2.0))
    (do ((bold-exp 10 (+ 1 bold-exp))) ((> bold-exp 20))
      ;(do ((neg-bold-exp 12 (+ 1 neg-bold-exp))) ((> neg-bold-exp 18))
        ;(do ((positive 1 (+ 1 positive))) ((> positive 15))
          ;(do ((negative 1 (+ 1 negative))) ((> negative 15))
            (sgp-fct `(
               :bold-scale ,scale
                ;:neg-bold-scale ,neg-scale
                :bold-exp ,bold-exp
                ;:neg-bold-exp ,neg-bold-exp
                ;:bold-positive ,positive
                ;:bold-negative ,negative
                :traced-buffers (,*module*))) ; <-------------------------------- set module to be traced here
            (let* ((key (read-from-string (concatenate 'string
                      "scale" (write-to-string scale)
                      ;"_neg-scale" (write-to-string neg-scale)
                      "_bold-exp" (write-to-string bold-exp)
                      ;"_neg-bold-exp" (write-to-string neg-bold-exp)
                      ;"_positive" (write-to-string positive)
                      ;"_negative" (write-to-string negative)
                      )))
                   (current (gethash key *bold-predictions-hash*)))
              (setf (gethash key *bold-predictions-hash*) (cons (cons trial (first (no-output (predict-bold-response start end)))) current))))));))))


(defun avg-hash-entry (key hash)
    (let* ((current (gethash key hash))
          (len (length (nthcdr 2 (first current))))
          (results (make-list len :initial-element 0)))
    (dolist (trial current)
        (do (( i 0 (+ 1 i))) ((>= i len))
            (setf (nth i results) (+ (nth i results) (nth i (nthcdr 2 trial))))))
            (mapcar #'(lambda(x) (/ x (float len))) results)))



; (getcorrelation *bold-predictions-hash* *lipfc-right-actr* nil)
; (getcorrelation *bold-predictions-hash* *ppc-right-fang* nil)
; (getcorrelation *bold-predictions-hash* *acc-right-actr* nil)
; (getcorrelation *bold-predictions-hash* *apfc-right-fang* nil)
; (getcorrelation *bold-predictions-hash* *caudate-right-actr* nil)
; (getcorrelation *bold-predictions-hash* *fusiform-right-actr* nil)
; (getcorrelation *bold-predictions-hash* *motor-left-actr* nil)

(defun getcorrelation (hash human results)
    (maphash #'(lambda (k v)
    (let* ((predictions (avg-hash-entry k hash))
          ;(c (length predictions))
          (c (correlation human predictions)))
    (setf results (cons (list k c) results))))
            hash)
            (let  ((sorted (sort results #'< :key #'second)))
            (dolist (r sorted) (format t "~%~s: ~20T~,5f" (first r)  (second r)))))


(defun set-bold-parameters (run)
    (setf *run* run)
   (dolist (x '(
    (retrieval       0.25 1 11 15 1 0)   ; SCALE 0.25   BOLD-EXP 11     0.75391
    (goal            0.12 1 17 15 1 0)   ; SCALE 0.12   BOLD-EXP 17     0.47731
    (imaginal        0.88 1 4  15 1 0)   ; SCALE 0.88   BOLD-EXP 4      0.72473
    ;(production      0.16 1 12 15 1 0)   ; SCALE 0.16   BOLD-EXP 12     0.42209
    (production      0.10 1 19 15 1 0)   ; SCALE0 0.10   BOLD-EXP 19    0.49916
    (visual          0.10 1 6  15 1 0)   ; SCALE 0.10   BOLD-EXP 6      0.43894
    (visual-location 0.75 1 6  15 1 0)
    (manual          0.90 1 2  15 1 0))) ; SCALE 0.90   BOLD-EXP 2      0.44929
        
    ;(retrieval       0.75 1 6 15 1 0)
    ;(goal            0.75 1 6 15 1 0)
    ;(imaginal        0.75 1 6 15 1 0)
    ;(production      0.75 1 6 15 1 0)
    ;(visual          0.75 1 6 15 1 0)
    ;(visual-location 0.75 1 6 15 1 0)
    ;(manual          0.75 1 6 15 1 0)))
        
    (setf *module*         (first   x)
          *bold-scale*     (second  x)
          *neg-bold-scale* (third   x)
          *bold-exp*       (fourth  x)
          *neg-bold-exp*   (fifth   x)
          *bold-positive*  (sixth   x)
          *bold-negative*  (seventh x))
    (load "load-fang2006.lisp")
    (do-experiment)))
