Readme
======

This folder contains the release code for the MPT evaluation on Wason Selection Task as a hypothesis testing.

## Contents

- `data/`: Contains data split into four and sixteen pattern categories.
- `models/`: Contains models split into four and sixteen pattern categories.
- `mpt/`: Contains function definitions for the fitting procedure and the command line interface.
- `fit_mle.py`: Program to perform Maximum Likelihood Estimation based fitting of MPTs.
- `fit_rmse.py`: Program to perform Root-Mean-Squared Error based fitting of MPTs.

## Requirements

Python 3 along with the following modules:

- numpy
- scipy
- pandas

## Exemplary usage

Choose `fit_mle.py` and `fit_rmse.py` depending on whether the MPTs are supposed to be fit based on Maximum Likelihood Estimation, or the Root-Mean-Squared Error metrics, respectively.

Both scripts have the same command line interface:

```plain
    usage: fit_rmse.py [-h] [-n N] [-s S] model data

    Perform generic fitting operations on MultinomialProcessing Trees (MPTs).

    positional arguments:
      model              Path to the MPT model specification file.
      data               Path to the data file in CSV format.

    optional arguments:
      -h, --help         show this help message and exit
      -n N, --n_optim N  Number of fitting repetitions to evade local maxima.
      -s S, --sep S      Data table column separator.
```

To run the MLE fitting procedure on the four pattern insight model and full dataset, execute the following command:

    $> python3 fit_rmse.py models/4pats/insight1970.model data/4pats/4pat-full.csv
