""" Script containing common command line argument parsing code.

| Copyright 2017 Cognitive Computation Lab
| University of Freiburg
| Nicolas Riesterer <riestern@tf.uni-freiburg.de>

"""

import argparse


def parse_commandlineargs():
    """ Extracts settings for the fitting run from the command line arguments.

    """

    parser = argparse.ArgumentParser(
        description='Perform generic fitting operations on Multinomial' + \
            'Processing Trees (MPTs).')

    # Mandatory arguments
    parser.add_argument(
        'model_filepath',
        metavar='model',
        type=str,
        help='Path to the MPT model specification file.')
    parser.add_argument(
        'data_filepath',
        metavar='data',
        type=str,
        help='Path to the data file in CSV format.')

    # Optional arguments
    parser.add_argument(
        '-n', '--n_optim',
        metavar='N',
        type=int,
        default=10,
        help='Number of fitting repetitions to evade local maxima.',)

    parser.add_argument(
        '-s', '--sep',
        metavar='S',
        type=str,
        default=',',
        help='Data table column separator.')

    args = parser.parse_args()
    return vars(args)
