Exemplary Model Specification
-----------------------------

This folder contains code implementing an exemplary model for the syllogistic reasoning challenge 2017.

## Files

- `main.py`: Command line interface of the model. Contains program entry point.
- `featureselection.py`: Implementation of the feature selection model of the atmosphere theory by Revlis, 1975.
- `modelbase.py`: Base-class for cognitive model implementations.

## Specification

- **Outputs**:
    - CSV table containing mean frequencies per answer possibility.

## Example

```
$> python cli.py
Syllog Aac, Iac, Eac, Oac, Aca, Eca, Ica, Oca, NVC
AA1 0.4903, 0.0, 0.0, 0.0, 0.5097, 0.0, 0.0, 0.0, 0.0
AA2 0.5073, 0.0, 0.0, 0.0, 0.4927, 0.0, 0.0, 0.0, 0.0
AA3 0.4934, 0.0, 0.0, 0.0, 0.5066, 0.0, 0.0, 0.0, 0.0
AA4 0.4943, 0.0, 0.0, 0.0, 0.5057, 0.0, 0.0, 0.0, 0.0
AI1 0.0, 0.4951, 0.0, 0.0, 0.0, 0.0, 0.5049, 0.0, 0.0
...
OO1 0.0, 0.0, 0.0, 0.5017, 0.0, 0.0, 0.0, 0.4983, 0.0
OO2 0.0, 0.0, 0.0, 0.5019, 0.0, 0.0, 0.0, 0.4981, 0.0
OO3 0.0, 0.0, 0.0, 0.5052, 0.0, 0.0, 0.0, 0.4948, 0.0
OO4 0.0, 0.0, 0.0, 0.4976, 0.0, 0.0, 0.0, 0.5024, 0.0
```
