Syllogism Challenge Readme
--------------------------

This README is supposed to answer core questions about the syllogism challenge. It starts by introducing the classical syllogisms, which are considered during the competition, as well as a general specification of the models to be submitted.

### Classical syllogisms

#### Moods of the syllogisms

The classical moods are as follows:

- Affirmative universal ("A", e.g. All A are B)
- Affirmative existential ("I", e.g. Some A are B)
- Negative universal ("E", e.g. No A are B)
- Negative existential ("O", e.g. Some A are not B)

#### Figures for the premises

There are four possible figures for the premises, where B is the middle term, which occurs in both premises, and A and C are the end terms, which occur in conclusions:

| Figure 1 | Figure 2 | Figure 3 | Figure 4 |
| ---------|----------|----------|----------|
| A–B      | B–A      | A–B      | B–A      |
| B–C      | C–B      | C–B      | B–C      |
| ---------|----------|----------|----------|

In total, there are 64 distinct syllogisms: 16 pairings of premises times 4 moods (e.g. AA1, AA2, AA3, AA4 are the four possible figures of the premise combination "All A are B" and "All B are C").

### Model Specification

For a demonstrative model implementation refer to the Python code in `modelexample/`. The data provided is split into two datasets:

- `khemlani-jl-2012.csv`: 156 participants
- `rg_2016.csv`: 20 participants

#### Output

The models are supposed to provide answers for all syllogisms in a table of dimensionality 64x10 corresponding to the 64 syllogisms (plus an optional header line) and 9 possible answers (Aac, Aca, Iac, Ica, Eac, Eca, Oac, Oca, NVC) plus the syllogism identifier. Aac means "All A are C", analogously for the other moods. NVC means "No Valid Conclusion". Numbers are probabilities that sum to one in each task, i.e. each row of the output.

**Example output**:

```
# Syllog Aac, Iac, Eac, Oac, Aca, Eca, Ica, Oca, NVC
AA1 0.4903, 0.0, 0.0, 0.0, 0.5097, 0.0, 0.0, 0.0, 0.0
AA2 0.5073, 0.0, 0.0, 0.0, 0.4927, 0.0, 0.0, 0.0, 0.0
AA3 0.4934, 0.0, 0.0, 0.0, 0.5066, 0.0, 0.0, 0.0, 0.0
AA4 0.4943, 0.0, 0.0, 0.0, 0.5057, 0.0, 0.0, 0.0, 0.0
AI1 0.0, 0.4951, 0.0, 0.0, 0.0, 0.0, 0.5049, 0.0, 0.0
...
OO1 0.0, 0.0, 0.0, 0.5017, 0.0, 0.0, 0.0, 0.4983, 0.0
OO2 0.0, 0.0, 0.0, 0.5019, 0.0, 0.0, 0.0, 0.4981, 0.0
OO3 0.0, 0.0, 0.0, 0.5052, 0.0, 0.0, 0.0, 0.4948, 0.0
OO4 0.0, 0.0, 0.0, 0.4976, 0.0, 0.0, 0.0, 0.5024, 0.0
```
