"""
    Copyright 2017 Cognitive Computation Lab
    University of Freiburg
    Nicolas Riesterer <riestern@tf.uni-freiburg.de>

    Generic base-class for syllogistic models.
"""

class CognitiveModel(object):
    """
    Minimalistic base-class for cognitive models. Each model necessarily
    requires a predict method for simulating responses to tasks.
    """

    def predict(self, task):
        """
        Method for generating predictions for given task identifiers.

        Args:
            task: String representation of the task to generate a prediction
                for (e.g. 'AA1').

        Returns:
            A string representation of the answer (e.g. 'Aac').
        """

        raise NotImplementedError("Predict method not implemented!")
