Examples
========

**Note:** The files contained in this examples folder were developed for CCOBRA version 0.0.3 (as of October 30th, 2018).

This folder contains the example files and models shown during the initial setup meeting of the WS2018 seminars on "Predicting Cognition via Machine Learning" and "Spatial Cognition".

All implemented models are valid for syllogistic single-choice datasets which are the main focus of the "Predicting Cognition via Machine Learning" seminar. Additional information about the "Spatial Cognition" seminar will be distributed via mail at a later date.

## Contents

- `custom_benchmark.json`: Custom benchmark containing the `baseline` benchmark as well as the example models
- `ccobra_bench`: Benchmark folder copied from the [ccobra repository](https://github.com/CognitiveComputationLab/ccobra)
- `example1.py`: Uniform random model implementation
- `example2.py`: Random model based on observation probabilities (uses `adapt`)
- `example3.py`: Pre-trained model based on repeated adaption to the training data

## Running the Model Benchmark

Custom models can be evaluated against a benchmark by executing the `runner.py` script:

```
$> cd /path/to/ccobra_bench
$> python runner.py /path/to/benchmark.json -m /path/to/custom_model.py
```

where `/path/to/...` needs to be replaced with the respective paths.

## Defining Custom Benchmarks

Benchmarks are defined in the JSON file format. To change datasets or add/remove models, modify the corresponding lines:

```
{
    "data.train": "/path/to/train_data.csv",
    "data.test": "/path/to/test_data.csv",
    "models": [
        "/path/to/model1.py",
        "/path/to/model2.py",
        "/path/to/model3.py"
    ]
}
```

**Note:** Paths in the benchmark files are interpreted as relative to the benchmark file's location. For instance, if the benchmark is located at `~/benchmarks/benchmark.json`, specifying the model `model.py` will result in the attempt of opening the file `~/benchmarks/model.py`. Specifying the model as `seminar/model.py` will attempt to read the file at `~/benchmarks/seminar/model.py`, instead.
