""" Example model 1

Generates predictions to single-choice syllogistic tasks by randomly sampling
from the set of choices.

"""

import ccobra
import numpy as np

class RandomModel(ccobra.CCobraModel):
    def __init__(self, name='RandomModel'):
        """ Initializes the RandomModel by calling the parent-class constructor
        and passing information about the name as well as supported domains
        and response-types.

        Parameters
        ----------
        name : str
            Name of the model. Will be used as an identifier throughout the
            evaluation phase. Should be unique.

        """

        super(RandomModel, self).__init__(
            name, ['syllogistic'], ['single-choice'])

    def predict(self, item, **kwargs):
        """ Generates a prediction based on a given task item.

        Parameters
        ----------
        item : ccobra.data.Item
            Task item container. Holds information about the task, domain,
            response type and response choices.

        Returns
        -------
        list(str)
            Single-choice syllogistic response in list representation (e.g.,
            ['All', 'managers', 'clerks']).

        """

        return np.random.choice(item.choices)
